//=============================================================================
// WeaponMarkusHammer, made by WCCC, with basecode by TNM peeps.
//=============================================================================
class WeaponMarkusHammer extends DeusExWeapon;

var travel int EffectMode; //what sideaffect are we giving?
var localized string EffectNames[14]; //messages to give upon mode change...
var Pawn JetPacker; //who is currently having jetpackarria?
var Pawn Ghostied; //who is having the ghosties?
var float GhostieTimer, JetPackTimer; //time related variables...
var bool bLongRange; //whether or not we've enabled extra range
var travel float AddedRange; //the extra range we've added...
var localized string RangeNames[4]; //messages for range...
var float AddedRanges[4]; //messages for range...
var Pawn Ghand; //who is having ghandaiah-ria
var travel int RangeMode; //which mode of range we're on...
var localized string OMFGNO, NOFUN; //misc messages...
var float GhandTime, GhandLeft;
var float SuperSonicTime, SuperSonicLeft; //super sonic diarrhia internal variables
var Pawn SuperSonic; //who is going super-sonic
var ParticleGenerator smokeGen;

#exec texture IMPORT NAME=LargeIconMSTNMHammer FILE=Textures\LargeIconTNMHammer.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconMSTNMHammer FILE=Textures\BeltIconTNMHammer.pcx GROUP=Skins MIPS=off

//First Person mesh
#exec mesh IMPORT MESH=WeaponMHammer ANIVFILE=C:\DeusEx\MSTNM\MODELS\WeaponMHammer_a.3d DATAFILE=C:\DeusEx\MSTNM\MODELS\WeaponMHammer_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponMHammer X=-16000 Y=2000 Z=0  //X - Toward Cam + Away Cam | Y - Right + Left | Z - Up  + Down

#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=All       STARTFRAME=0    NUMFRAMES=58
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Select	STARTFRAME=1	NUMFRAMES=6		RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Attack	STARTFRAME=6	NUMFRAMES=8		RATE=21
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Attack2	STARTFRAME=13	NUMFRAMES=8	    RATE=33
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Attack3	STARTFRAME=20	NUMFRAMES=11	RATE=24
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Down		STARTFRAME=30	NUMFRAMES=6		RATE=10
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Idle1		STARTFRAME=36	NUMFRAMES=8		RATE=4
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Idle2		STARTFRAME=43	NUMFRAMES=8		RATE=4
#exec mesh SEQUENCE MESH=WeaponMHammer SEQ=Idle3		STARTFRAME=50	NUMFRAMES=8		RATE=4

#exec mesh NOTIFY MESH=WeaponMHammer SEQ=Attack		TIME=0.33	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponMHammer SEQ=Attack2		TIME=0.33	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponMHammer SEQ=Attack3		TIME=0.33	FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=WeaponMHammer1 FILE=C:\DeusEx\MSTNM\Textures\MHammerTex1.PCX GROUP=Skins // HAMMER
#exec texture IMPORT NAME=JWeaponHammer2 FILE=C:\DeusEx\MSTNM\Textures\WeaponHandsTex.PCX GROUP=Skins // HAMMER

#exec MESHMAP NEW   MESHMAP=WeaponMHammer MESH=WeaponMHammer
#exec MESHMAP scale MESHMAP=WeaponMHammer X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponMHammer NUM=1 TEXTURE=WeaponMHammer1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponMHammer NUM=2 TEXTURE=JWeaponHammer2


//Pickup mesh
#exec mesh IMPORT MESH=MHammerPickup ANIVFILE=C:\DeusEx\MSTNM\MODELS\MHammerPickup_a.3d DATAFILE=C:\DeusEx\MSTNM\MODELS\MHammerPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MHammerPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=MHammerPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=MHammerPickup SEQ=MHammerPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=MHammerPickup MESH=MHammerPickup
#exec MESHMAP SCALE MESHMAP=MHammerPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MHammerPickup NUM=1 TEXTURE=WeaponMHammer1


//3rd Person mesh
#exec mesh IMPORT MESH=MHammer3rd ANIVFILE=C:\DeusEx\MSTNM\MODELS\MHammer3rd_a.3d DATAFILE=C:\DeusEx\MSTNM\MODELS\MHammer3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MHammer3rd X=3000 Y=500 Z=0

#exec MESH SEQUENCE MESH=MHammer3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MHammer3rd SEQ=MHammer3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=MHammer3rd MESH=MHammer3rd
#exec MESHMAP SCALE MESHMAP=MHammer3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MHammer3rd NUM=1 TEXTURE=WeaponMHammer1

//let us change the range manually
function LaserToggle()
{
 //unless it would just be a fucking terrible idea!
 if (EffectMode == 5 || EffectMode == 8)
 {
  Pawn(Owner).ClientMessage(OMFGNO);
  return;
 }
 /*if (EffectMode == 12)
 {
  Pawn(Owner).ClientMessage(NOFUN);
  return;
 }*/
 RangeMode++;

 if (RangeMode > 3) RangeMode = 0;
 AddedRange = AddedRanges[RangeMode];
 MaxRange = 80 + AddedRange;
 AccurateRange = 80 + AddedRange;
 Default.MaxRange = MaxRange;
 Default.AccurateRange = AccurateRange;
 Pawn(Owner).ClientMessage(RangeNames[RangeMode]);
 return;
}

function OhGodThePockets()
{
 local int f, u;

  if (Ghand == None)
  {
   GhandLeft = 0;
   GhandTime = 0;
   return;
  }
  for (f=0;f<3;f++)
  {
   Spawn(class'DiarrhiaFragment',,,Ghand.Location + (vect(0,1,0) * Ghand.CollisionRadius >> Ghand.Rotation),Ghand.RotRand(True));
  }
  for (u=0;u<3;u++)
  {
   Spawn(class'DiarrhiaFragment',,,Ghand.Location + (vect(0,-1,0) * Ghand.CollisionRadius >> Ghand.Rotation),Ghand.RotRand(True));
  }
}

function SonicBoom()
{
 local int u;

       if (smokeGen == None)
       {
 	smokeGen = Spawn(class'ParticleGenerator', SuperSonic,,SuperSonic.Location,SuperSonic.Rotation);
	if (smokeGen != None)
	{
      smokeGen.RemoteRole = ROLE_None;
		smokeGen.particleTexture = Texture'DeusExItems.Skins.FlatFXTex41';
		smokeGen.particleDrawScale = 0.2;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 0.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 1.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(SuperSonic);
	}
       }
  SuperSonic.Velocity += vect(1250,0,160) >> SuperSonic.Rotation;
  SuperSonic.Acceleration = SuperSonic.Velocity;
  SuperSonic.SetCollisionSize(SuperSonic.Default.CollisionRadius / 2, SuperSonic.Default.CollisionHeight / 2);
  if (SuperSonic.Physics != PHYS_Falling) SuperSonic.SetPhysics(PHYS_Falling);

if (VSize(SuperSonic.Velocity * (vect(1,0,0) >> SuperSonic.Rotation)) > VSize(SuperSonic.Velocity * (vect(0,1,0) >> SuperSonic.Rotation)))
{
 if (!FastTrace(SuperSonic.Location + (vect(50,0,0) >> SuperSonic.Rotation), SuperSonic.Location) || !FastTrace(SuperSonic.Location - (vect(50,0,0) >> SuperSonic.Rotation), SuperSonic.Location))
 {
  SuperSonic.Health -= 25;
  SuperSonic.PlaySound(sound'CrowbarHitFlesh', SLOT_None,,,2048);
 }
}
if (VSize(SuperSonic.Velocity * (vect(0,1,0) >> SuperSonic.Rotation)) > VSize(SuperSonic.Velocity * (vect(1,0,0) >> SuperSonic.Rotation)))
{
 if (!FastTrace(SuperSonic.Location + (vect(0,50,0) >> SuperSonic.Rotation), SuperSonic.Location) || !FastTrace(SuperSonic.Location - (vect(0,50,0) >> SuperSonic.Rotation), SuperSonic.Location))
 {
  SuperSonic.Health -= 25;
  SuperSonic.PlaySound(sound'CrowbarHitFlesh', SLOT_None,,,2048);
 }
}
  for (u=0;u<2;u++)
  {
   Spawn(class'DiarrhiaFragment',,,SuperSonic.Location + (vect(-1,0,0) * SuperSonic.CollisionRadius >> SuperSonic.Rotation),SuperSonic.RotRand(True));
  }
}

function Tick(float DT)
{
local Fragment chunk;
local int i, f, u;
local float size;
local Vector loc, Ghandloc;

 Super.Tick(DT);

 if ((JetPacker != None) && (JetPacker.IsInState('Dying')))
 {
  JetPackTimer = 0;
  JetPacker = None;
 }

 if ((Ghostied != None) && (Ghostied.IsInState('Dying')))
 {
  GhostieTimer = 0;
  Ghostied = None;
 }

 if ((Ghand != None) && (Ghand.IsInState('Dying')))
 {
  GhandTime = 0;
  Ghand = None;
  GhandLeft = 0;
 }

 if ((SuperSonic != None) && (SuperSonic.IsInState('Dying')))
 {
  SuperSonicTime = 0;
  SuperSonic = None;
  SuperSonicLeft = 0;
	if (smokeGen != None)
	{
	 smokeGen.DelayedDestroy();
	}
 }

 if (SuperSonicTime > 0 && SuperSonicLeft > 0)
 {
  SuperSonicTime -= DT;
 }
 if (SuperSonicLeft > 0 && SuperSonic != None)
 {
  SuperSonicLeft -= DT;
 }

 if (SuperSonicTime < 0) 
 {
  SuperSonicTime = 0.175;
  SonicBoom();
 }

 if (SuperSonicLeft < 0 || (SuperSonic.Health < 10 && SuperSonic != None))
 {
  SuperSonicTime = 0;
  SuperSonicLeft = 0;
  SuperSonic.Health = -10000;
  SuperSonic.SpawnCarcass();
  SuperSonic.PlaySound(sound'LargeExplosion1', SLOT_None,,,4096); //play an exploding sound!
  Spawn(class'ExplosionMedium',,,SuperSonic.Location);
  for(i=0;i<8;i++)
  {
   Spawn(Class'FleshFragment',,,SuperSonic.Location - (vect(40,0,0) >> SuperSonic.Rotation),SuperSonic.RotRand(True));
  }
  if (PlayerPawn(SuperSonic) == None) SuperSonic.Destroy();
	if (smokeGen != None)
	{
	 smokeGen.DelayedDestroy();
	}
  SuperSonic = None;
 }

 if (GhandTime > 0 && GhandLeft > 0)
 {
  GhandTime -= DT;
 }
 if (GhandLeft > 0 && Ghand != None)
 {
  GhandLeft -= DT;
 }
 if (GhandLeft == 0 && GhandTime > 0) GhandTime = 0;
 if (GhandTime < 0) 
 {
  GhandTime = 0.25;
  OHGODTHEPOCKETS();
 }
 
 if (GhandLeft < 0)
 {
  GhandTime = 0;
  GhandLeft = 0;
  GhandLoc = Ghand.Location;
  Ghand.Health = -10000;
  Ghand.SpawnCarcass();
  Ghand.PlaySound(sound'LargeExplosion1', SLOT_None,,,4096); //play an exploding sound!
  if (PlayerPawn(Ghand) == None) Ghand.Destroy();
  Spawn(class'ExplosionLarge',,,GhandLoc);
  ghand = Spawn(class'GuntherHermann',,,GhandLoc,RotRand(False));
  BroadcastMessage("|p4Actual Ghand not available, get TNM dammit");
  ghand.TakeDamage(1,Pawn(Owner),vect(0,0,0),vect(0,0,0), 'flamed');
  ghand = None;
 }
 
 if ((JetPacker != None) && (JetPackTimer > 0))
  JetPackTimer -= DT; //count down till next crapping

 if ((Ghostied != None) && (GhostieTimer > 0))
  GhostieTimer -= DT; //count down till ghosties strike

 if (JetPackTimer < 0)
 {
  JetPackTimer = 0.500000; //next blast in half a second
  JetPacker.SetPhysics(PHYS_Falling); //make us able to fly
  JetPacker.Velocity.Z += 1000; //make us fly!

		if (JetPacker.CollisionHeight > 0 && JetPacker.CollisionRadius > 0)
                {
		size = (JetPacker.CollisionRadius + JetPacker.CollisionHeight) / 2; //make us shit ourselves uncontrollabley
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * JetPacker.CollisionRadius;
				loc.Y = (1-2*FRand()) * JetPacker.CollisionRadius;
				loc.Z = (1-2*FRand()) * JetPacker.CollisionHeight;
				loc += JetPacker.Location;
				chunk = spawn(class'DiarrhiaFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = JetPacker.RotRand(False);
				}
			}
		}
  //make us gib after we take enough damage...
  //then make us explode and force us to gib...
  if ((JetPacker.Health <= JetPacker.Default.Health / 7.5) || (JetPacker.HealthTorso <= JetPacker.Default.Health / 7.5))
  {
   JetPacker.PlaySound(sound'LargeExplosion1', SLOT_None,,,4096); //play an exploding sound!
   Spawn(Class'ExplosionLarge',,,JetPacker.Location);
   JetPacker.TakeDamage(10000, Pawn(Owner), JetPacker.Location, vect(0,0,0), 'Exploded');
   //force gib h4x begin
   JetPacker.Acceleration = vect(0,0,0);
   JetPacker.SpawnCarcass();
   if (PlayerPawn(JetPacker) == None) JetPacker.Destroy();
   //force gib h4x end
   JetPacker = None;
   JetPackTimer = 0;
  }
  else if ((JetPacker.Health > JetPacker.Default.Health / 7.5) && (JetPacker.HealthTorso > JetPacker.Default.Health / 7.5))
   JetPacker.TakeDamage(JetPacker.Default.Health / 7.5, Pawn(Owner), JetPacker.Location, vect(0,0,0), 'Exploded');
 }
 if (GhostieTimer < 0)
 {
  GhostieTimer = 0;
  loc.X = (1-2*FRand()) * Ghostied.CollisionRadius;
  loc.Y = (1-2*FRand()) * Ghostied.CollisionRadius;
  loc.Z = (1-2*FRand()) * Ghostied.CollisionHeight;
  loc += Ghostied.Location;
  chunk = spawn(class'GhostieFragment', None,, loc);
  if (chunk != None)
  {
	chunk.RotationRate = RotRand(False);
	chunk.bFixedRotationDir = True;
  }
  Ghostied.TakeDamage(1000, Pawn(Owner), JetPacker.Location, vect(0,0,0), 'Sabot');
  Ghostied = None;
 }
}

function SpawnWormholeEffects(Vector Wormhole1, Vector Wormhole2)
{
 local sphereeffect WH1, WH2;
 local Fragment chunk;
 local int i;
 local float size;
 local Vector loc;

 WH1 = Spawn(class'SphereEffect',,, WormHole1);
 WH2 = Spawn(class'SphereEffect',,, WormHole2); 
 size = 68.000000; //assume adult pawn size
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * 40;
				loc.Y = (1-2*FRand()) * 40;
				loc.Z = (1-2*FRand()) * 96;
				loc += Wormhole2; //spawn some supernatural shit at the exit point
				chunk = spawn(class'WormHoleFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
			}

}

function SpawnWormHoleGiblets(Vector WHLoc)
{
 local Fragment chunk;
 local int i;
 local float size;
 local Vector loc;

 size = 68.000000; //assume adult pawn size
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * 40;
				loc.Y = (1-2*FRand()) * 40;
				loc.Z = (1-2*FRand()) * 96;
				loc += WHLoc; //spawn some supernatural gibs at the exit point
				chunk = spawn(class'WormHoleGiblet', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
			}

}

function MoveVictim(Pawn Victim)
{
	local actor a;
	local int numactors, i, n;
	local actor LevelActors[256];
	
		foreach allactors (class'Actor', a)
			if ((A.IsA('Decoration')) && (!A.Region.Zone.IsA('SkyZoneInfo')))
                        //make us pop up somewhere completely random OTHER than the sky box...
			// only use these actors for a starting point
			{
				numactors++;
				if (NumActors < 256) // dont go outside our array
					LevelActors[NumActors] = A; // add the actor to the list
				else
					break;
			}	
			n = Rand(NumActors); // pick a random actor from the list we just made
			TeleportVictim(Victim, LevelActors[n]); // teleport the victim using that actor
}

function TeleportVictim(Pawn Subject, Actor DestinationActor)
{
	local vector OrigLocation, Destination, DestNormal, EndTrace, Correction, RVect;
	local int i;	
	local actor hit;

	if (Subject == None)
		return;

	OrigLocation = Subject.Location;

	for (i=0;i<5;i++)
	{
		RVect = VRand();
		RVect.Z = 0;
		EndTrace = DestinationActor.Location + RVect*65536; // some vector very far away in a random direction ferom the DestinationActor
		hit = DestinationActor.Trace(Destination, DestNormal, EndTrace, DestinationActor.Location, True); // find where this line hits a wall
	/*	if (Destination.Z - OrigLocation.Z > MaxZ)
		{
			Correction = Destination;
			Correction.Z = OrigLocation.Z + MaxZ;
			hit = DestinationActor.Trace(Destination, DestNormal, EndTrace, OrigLocation, True);*/ // okay stuff 3D
		Destination += DestNormal*Subject.CollisionHeight; // we dont want them half in a wall/floor
        	SpawnWormholeEffects(OrigLocation, Destination);
		if(Subject.SetLocation(Destination)) // make sure they got there
		{				     //and if we did do some damage or just gib us if we're too weak
                       if ((Subject.Health > Subject.Default.Health / 3) && (Subject.HealthTorso > Subject.Default.Health / 3))
			Subject.TakeDamage(Subject.Default.Health / 3, Pawn(Owner), Subject.Location, vect(0,0,0), 'Exploded');
                       if ((Subject.Health <= Subject.Default.Health / 3) || (Subject.HealthTorso <= Subject.Default.Health / 3))
		       {
		        if (Subject.IsA('ScriptedPawn'))
			{
			 //ScriptedPawn(Subject).DropItems(); //make them drop any items they are carrying
			}
			SpawnWormHoleGiblets(Destination); //then spawn supernatural giblets
			if (PlayerPawn(Subject) == None) Subject.Destroy(); //and finally destroy them in a way that looks completely believable
			return;
		       }
		}
	}
	//BroadcastMessage("|P2Failed to move victim.");		
}

function CycleAmmo()
{
 EffectMode++;
if (EffectMode > 13)
 EffectMode = 0;

Pawn(Owner).ClientMessage(EffectNames[EffectMode]);

 //handle the REALY dangerous stuff from a longer range...
 if ((EffectMode == 5) || (EffectMode == 8))
 {
  MaxRange = 3072;
  AccurateRange = 3072;
  Pawn(Owner).ClientMessage(RangeNames[3]);
 }
 /*if (EffectMode == 12)
 {
  MaxRange = 80;
  AccurateRange = 80;
  Pawn(Owner).ClientMessage(RangeNames[0]);
 }*/

 //and fix it if its not...
 else if (EffectMode != 11 && EffectMode != 5 && EffectMode != 8)
 {
  MaxRange = 80 + AddedRange;
  AccurateRange = 80 + AddedRange;
 }

 if (EffectMode == 10) //ghosties kills you only when it finally comes out...
  HitDamage = 0;
 if (EffectMode == 11)
  HitDamage = 0;
 if (EffectMode == 6) //and the wormhole should only do damage after you go through it...
  HitDamage = 0;
 else if (EffectMode != 6 && EffectMode != 10 && EffectMode != 11) //but everything else just does normal damage...
  HitDamage = 13;
 //update the descriptor crap!
 Default.MaxRange = MaxRange;
 Default.AccurateRange = AccurateRange;
 Default.HitDamage = HitDamage;
}

function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
local pawn OHGODTHEPOKETS;
local DiarrhiaFragment chunk;
local Lam ClusterBombs;
local int i;
local int j;
local float size;
local Vector loc;
local int totalskinny;

 if (Other.IsA('Pawn'))
 {
  OHGODTHEPOKETS = Pawn(Other);

		if (EffectMode == 1) //explosive diarrhia
		{
		 totalskinny = int(OHGODTHEPOKETS.Fatness) + Damage;
                  //if we've fattened enough, blow us to bits!
                  if (totalskinny >= 255)
		   OHGODTHEPOKETS.TakeDamage(10000, Pawn(Owner), JetPacker.Location, vect(0,0,0), 'Exploded');
		 OHGODTHEPOKETS.Fatness += Damage;
		}
		if (EffectMode == 2) //implosive diarrhia
		{
		 totalskinny = int(OHGODTHEPOKETS.Fatness) - Damage * 2;
                  //if we've imploded enough, blow us to bits!
                  if (totalskinny <= 64)
		   OHGODTHEPOKETS.TakeDamage(10000, Pawn(Owner), JetPacker.Location, vect(0,0,0), 'Exploded');
		 OHGODTHEPOKETS.Fatness -= Damage * 2;
		}

                //and don't forget to make them shit themselves on any mode BUT the ghosties...
		size = (OHGODTHEPOKETS.CollisionRadius + OHGODTHEPOKETS.CollisionHeight) / 2;
		if (size > 10.0)
		{
			for (i=0; i<size/4.0; i++)
			{
                                if (EffectMode == 10 || EffectMode == 12) //ghostie safe-locks
                                break;
				loc.X = (1-2*FRand()) * OHGODTHEPOKETS.CollisionRadius;
				loc.Y = (1-2*FRand()) * OHGODTHEPOKETS.CollisionRadius;
				loc.Z = (1-2*FRand()) * OHGODTHEPOKETS.CollisionHeight;
				loc += OHGODTHEPOKETS.Location;
				chunk = spawn(class'DiarrhiaFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = OHGODTHEPOKETS.RotRand(False);
				}
			}
                       if (EffectMode == 8) //clusterbombs OH NOES!
			for (j=0; j<4; j++)
			{
				loc.X = (1-2*FRand()) * OHGODTHEPOKETS.CollisionRadius;
				loc.Y = (1-2*FRand()) * OHGODTHEPOKETS.CollisionRadius;
				loc.Z = (1-2*FRand()) * OHGODTHEPOKETS.CollisionHeight;
				loc += OHGODTHEPOKETS.Location;
				ClusterBombs = spawn(class'Lam', None,, loc);
				if (ClusterBombs != None)
				{
					ClusterBombs.DrawScale = size / 25;
					ClusterBombs.SetCollisionSize(ClusterBombs.CollisionRadius / ClusterBombs.DrawScale, ClusterBombs.CollisionHeight / ClusterBombs.DrawScale);
					ClusterBombs.bFixedRotationDir = True;
					ClusterBombs.RotationRate = OHGODTHEPOKETS.RotRand(False);
				}
			}
		}
 if (EffectMode == 6) //wormholes... gotta love em.
  MoveVictim(OHGODTHEPOKETS);
 if (EffectMode == 5) //blackholes too.
  Spawn(Class'BlackHole',,,HitLocation); //i assume the user knows that a black hole is dangerous...
 if (EffectMode == 12)
 {
  OHGODTHEPOKETS.SetCollisionSize(0,0);
  OHGODTHEPOKETS.Health = -1;
  Spawn(class'OMGWWTP',,,OHGODTHEPOKETs.Location);
 }
 if (EffectMode == 13)
 {
  OHGODTHEPOKETS.SetPhysics(PHYS_Falling);
  SuperSonic = OHGODTHEPOKETS;
  SuperSonicLeft = 4.5;
  SuperSonicTime = 0.2;
  OHGODTHEPOKETS.SetCollisionSize(OHGODTHEPOKETS.Default.CollisionRadius / 2, OHGODTHEPOKETS.Default.CollisionHeight / 2);
 }
 if (EffectMode == 11)
 {
  Ghand = OHGODTHEPOKETS;
  GhandLeft = 5;
  GhandTime = 0.2;
 }
 if (EffectMode == 7 || EffectMode == 12) //give them jetpackarria
  {
   JetPacker = OHGODTHEPOKETS;
   JetPackTimer = 0.1;
  }
  if (EffectMode == 10) //or give them the ghosties
  {
   Ghostied = OHGODTHEPOKETS;
   GhostieTimer = 5;
  }
 }
  if (EffectMode == 9) //nuclear blitz emp damage
   Other.TakeDamage(Damage * 5, Pawn(Owner), Other.Location, vect(0,0,0), 'EMP');
 Super.SpawnEffects(HitLocation, HitNormal, Other, Damage);
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local thrownprojectile nade;

	nade=ThrownProjectile(other);
	if(nade!=None)
	{
		if(!nade.bDisabled)
			nade.Frob(None,None);
		return;
	}

	super.ProcessTraceHit(Other,HitLocation,HitNormal,X,Y,Z);
}

function name WeaponDamageType()
{
      if (EffectMode == 3)
       return ('flamed'); //molten diarrhia

      else if (EffectMode == 4)
       return ('poison'); //acidic diarrhia
      
      else if (EffectMode == 5)
       return ('Exploded'); //blackhole

      else if (EffectMode == 9)
       return ('knockedout'); //nuclear blitzarria

      else if (EffectMode == 0)
       return ('shot'); //normal diarrhia

      else if (EffectMode == 11)
       return ('Stunned'); //ghandaiah-ria!

      else
       return ('fat'); //anything else
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 MaxRange = 80 + AddedRange;
 AccurateRange = 80 + AddedRange;
}

defaultproperties
{
     Misc1Sound=Sound'DeusExSounds.Weapons.CrowbarHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CrowbarHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CrowbarHitSoft'
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_All
     reloadTime=0.000000
     HitDamage=13
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     bEmitWeaponDrawn=False
     mpHitDamage=20
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CrowbarFire'
     SelectSound=Sound'DeusExSounds.Weapons.CrowbarSelect'
     InventoryGroup=255
     ItemArticle=""
     ItemName="|p3Markus's Hammer of Lulzitude"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'MSTNM2.WeaponMHammer'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'MSTNM2.MHammerPickup'
     PickupViewScale=0.600000
     ThirdPersonMesh=LodMesh'MSTNM2.MHammer3rd'
     ThirdPersonScale=0.350000
     Icon=Texture'MSTNM2.BeltIconMSTNMHammer'
     largeIcon=Texture'MSTNM2.LargeIconMSTNMHammer'
     largeIconWidth=49
     largeIconHeight=45
     Description="|p7ZOMFG EASTER EGG WEAPON: |n|cf88TIP: USE CHANGE AMMO BUTTON TO CHANGE MODES AND LASER TOGGLE BUTTON TO CHANGE RANGE!|n|p4A strange hammer that has the name 'Markus' Embedded in the side along with a label that reads: WARNING: Sideaffects may include diarrhia, explosive diarrhia, implosive diarrhia, molten diarrhia, acidic diarrhia, Black Hole-arria, Worm Hole-arria, JetPack-arria, Cluster Bomb-arria, Nuclear Blitz-arria, 'the ghosties', Ghandaiahrria (OH GOD THE POCKETS!), OMGWWTP, and Super-Sonic Diarrhia. Please consult your doctor if you have diarrhia lasting longer than 4 hours."
     beltDescription="|p3OH SHI-"
     Mesh=LodMesh'MSTNM2.MHammerPickup'
     CollisionRadius=12.650000
     CollisionHeight=1.200000
     EffectNames(0)="|cabd91cSideaffect set to diarrhia #1"
     EffectNames(1)="|cffbd0dSideaffect set to explosive diarrhia #2"
     EffectNames(2)="|cff80ffSideaffect set to implosive diarrhia #3"
     EffectNames(3)="|cf88Sideaffect set to molten diarrhia #4"
     EffectNames(4)="|p3Sideaffect set to acidic diarrhia #5"
     EffectNames(5)="|ca900a9Sideaffect set to Black Hole-arrhia #6"
     EffectNames(6)="|c59a4ffSideaffect set to Worm Hole-arrhia #7"
     EffectNames(7)="|c546711Sideaffect set to Jetpack-arrhia #8"
     EffectNames(8)="|p2Sideaffect set to Cluster Bomb-arrhia #9"
     EffectNames(9)="|p7Sideaffect set to Nuclear Blitz-arrhia #10"
     EffectNames(10)="|p1Sideaffect set to 'the ghosties' #11"
     EffectNames(11)="|p4Sideaffect set to 'Ghandaiah-rrhia' #12"
     EffectNames(12)="|p7Sideaffect set to OMGWWTP #13"
     EffectNames(13)="|p1Sideaffect set to |p7Super-Sonic Diarrhia #14"
     RangeNames(0)="|cf88Range Set To 2 1/2 Feet."
     RangeNames(1)="|p4Range Set To 61 1/2 Feet."
     RangeNames(2)="|p3Range Set To 125 1/2 Feet."
     RangeNames(3)="|p7Range Set To 189 1/2 Feet."
     AddedRanges(0)=0
     AddedRanges(1)=1024
     AddedRanges(2)=2048
     AddedRanges(3)=3072
     OMFGNO="|cf88Trust me, you don't want to do that!"
     NOFUN="|cf88That's No Fun!"
}
